<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_ControllerPublic_Post extends XFCP_sonnbStopSpamHere_ControllerPublic_Post
{
	public function actionMarkSpam()
	{
		$postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);

		if ($this->isConfirmedPost())
		{
			if ($post['position'])
			{
				/*
				 * Set post to moderated state if this is not first post
				 */
				$postDw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
				$postDw->setExistingData($post['post_id']);
				$postDw->set('message_state', 'moderated');
				$postDw->save();
				
				$redirectTarget = XenForo_Link::buildPublicLink('threads', $thread);
			}
			else
			{
				/*
				 * This is the first post, set the thread into moderated
				 */
				$threadDw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
				$threadDw->setExistingData($thread['thread_id']);
				$threadDw->set('discussion_state', 'moderated');
				$threadDw->save();
				
				$redirectTarget = XenForo_Link::buildPublicLink('forums', $forum);
			}
			
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				$redirectTarget,
				new XenForo_Phrase('sonnbStopSpamHere_thank_you_that_post_was_sent_to_moderator')
			);
		}
		else
		{
			/*
			 * Show form to user to confirm that they are really want to mark this post as spam
			 */
			return $this->responseView(
				'sonnbStopSpamHere_ViewPublic_Post_MarkSpam',
				'sonnbStopSpamHere_confirm_mark_spam_post',
				array(
					'post' => $post,
					'thread' => $thread,
					'forum' => $forum
				)
			);
		}
	}

	
}